% ppmunpack	inverse of ppmpack
%		
%	function [R,G,B] = ppmunpack(C)
% or
%       

%         M Jagersand Nov 94

function [R,G,B] = ppmunpack(C)

% [m,n] = size(R);
% if nargout == 3
% This was intended to be more efficient in case of only one output arg,
% but fails when one has a RGB, but only wants the R image

  R = zeros(C(1),C(2));
  G = zeros(C(1),C(2));
  B = zeros(C(1),C(2));

  Csize = 3*C(1)*C(2)+2;
  reds = 3:3:Csize;

  if length(C(:)) == Csize        % We have a true color image
    R(:) = C(reds);
    G(:) = C(reds+1);
    B(:) = C(reds+2);
  else                            % BW image, expand to RGB
    R(:) = C(3:C(1)*C(2)+2);
    G(:) = C(3:C(1)*C(2)+2);
    B(:) = C(3:C(1)*C(2)+2);
  end
% else			          % BW image
%  Csize = C(1)*C(2)+2;
%  R = zeros(C(1),C(2));
%  R(:) = C(3:C(1)*C(2)+2);
% end
  
