% Copyright 2011 Zdenek Kalal
%
% This file is part of TLD.
% 
% TLD is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% TLD is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with TLD.  If not, see <http://www.gnu.org/licenses/>.

function [nX,nEx] = tldGenerateAprioriData(tld)

nX  = [];
nEx = [];

files = img_dir(tld.apriori);
if isempty(files), return; end

for i = 1:length(files)
    
    img = img_alloc(files(i).name);
    
    img.input = imresize(img.input,tld.imgsize);
    img.blur  = imresize(img.blur,tld.imgsize);
    
    [tnX,status] = fern(5,img,1:tld.nGrid,tld.var/2);
    nX          = [nX tnX(:,status==1)];

    idx = randvalues(1:tld.nGrid,500);
    bb  = tld.grid(1:4,idx);
    nEx = [nEx tldGetPattern(img,bb,tld.patchsize)];
    
end
